import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import mods.gregtech.recipe.RecipeMap;
import mods.pyrotech.StoneSawmill as StoneSawmill;
import mods.pyrotech.GraniteAnvil;
import mods.astralsorcery.Altar as Altar;
import mods.enderio.SagMill as SagMill;
import mods.advancedrocketry.CuttingMachine;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//			         																														 //
//			Wood Planks and Slabs Rework                                                                                                     //
//			         																														 //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Removing Log of Oak Planks in the Macerator
//macerator.findRecipe(8, [<forestry:logs.5>], null).remove();

var Woods as IItemStack[IIngredient] = {
    <minecraft:log2:0>: <minecraft:planks:4>,
    <minecraft:log2:1>: <minecraft:planks:5>,
    <minecraft:log:0>: <minecraft:planks:0>,
    <minecraft:log:1>: <minecraft:planks:1>,
    <minecraft:log:2>: <minecraft:planks:2>,
    <minecraft:log:3>: <minecraft:planks:3>,
    <gregtech:rubber_log>: <gregtech:planks>,
    <integrateddynamics:menril_log:0>: <integrateddynamics:menril_planks:0>,
    <biomesoplenty:log_0:4>: <biomesoplenty:planks_0:0>,
    <biomesoplenty:log_0:5>: <biomesoplenty:planks_0:1>,
    <biomesoplenty:log_0:6>: <biomesoplenty:planks_0:2>,
    <biomesoplenty:log_0:7>: <biomesoplenty:planks_0:3>,
    <biomesoplenty:log_1:4>: <biomesoplenty:planks_0:4>,
    <biomesoplenty:log_1:5>: <biomesoplenty:planks_0:5>,
    <biomesoplenty:log_1:6>: <biomesoplenty:planks_0:6>,
    <biomesoplenty:log_1:7>: <biomesoplenty:planks_0:7>,
    <biomesoplenty:log_2:4>: <biomesoplenty:planks_0:8>,
    <biomesoplenty:log_2:5>: <biomesoplenty:planks_0:9>,
    <biomesoplenty:log_2:6>: <biomesoplenty:planks_0:10>,
    <biomesoplenty:log_2:7>: <biomesoplenty:planks_0:11>,
    <biomesoplenty:log_3:4>: <biomesoplenty:planks_0:12>,
    <biomesoplenty:log_3:5>: <biomesoplenty:planks_0:13>,
    <biomesoplenty:log_3:6>: <biomesoplenty:planks_0:14>,
    <biomesoplenty:log_3:7>: <biomesoplenty:planks_0:15>,
    //<rustic:log:0>: <rustic:planks:0>,
    //<rustic:log:1>: <rustic:planks:1>,
    <harvestcraft:pamcinnamon:0>: <minecraft:planks:3>,
    <harvestcraft:pammaple:0>: <minecraft:planks:1>,
    <harvestcraft:pampaperbark:0>: <minecraft:planks:3>,
    <forestry:logs.0:0>: <forestry:planks.0:0>,
    <forestry:logs.0:1>: <forestry:planks.0:1>,
    <forestry:logs.0:2>: <forestry:planks.0:2>,
    <forestry:logs.0:3>: <forestry:planks.0:3>,
    <forestry:logs.1:0>: <forestry:planks.0:4>,
    <forestry:logs.1:1>: <forestry:planks.0:5>,
    <forestry:logs.1:2>: <forestry:planks.0:6>,
    <forestry:logs.1:3>: <forestry:planks.0:7>,
    <forestry:logs.2:0>: <forestry:planks.0:8>,
    <forestry:logs.2:1>: <forestry:planks.0:9>,
    <forestry:logs.2:2>: <forestry:planks.0:10>,
    <forestry:logs.2:3>: <forestry:planks.0:11>,
    <forestry:logs.3:0>: <forestry:planks.0:12>,
    <forestry:logs.3:1>: <forestry:planks.0:13>,
    <forestry:logs.3:2>: <forestry:planks.0:14>,
    <forestry:logs.3:3>: <forestry:planks.0:15>,
    <forestry:logs.4:0>: <forestry:planks.1:0>,
    <forestry:logs.4:1>: <forestry:planks.1:1>,
    <forestry:logs.4:2>: <forestry:planks.1:2>,
    <forestry:logs.4:3>: <forestry:planks.1:3>,
    <forestry:logs.5:0>: <forestry:planks.1:4>,
    <forestry:logs.5:1>: <forestry:planks.1:5>,
    <forestry:logs.5:2>: <forestry:planks.1:6>,
    <forestry:logs.5:3>: <forestry:planks.1:7>,
    <forestry:logs.6:0>: <forestry:planks.1:8>,
    <forestry:logs.6:1>: <forestry:planks.1:9>,
    <forestry:logs.6:2>: <forestry:planks.1:10>,
    <forestry:logs.6:3>: <forestry:planks.1:11>,
    <forestry:logs.7:0>: <forestry:planks.1:12>,
    <forestry:logs.fireproof.0:0>: <forestry:planks.fireproof.0:0>,
    <forestry:logs.fireproof.0:1>: <forestry:planks.fireproof.0:1>,
    <forestry:logs.fireproof.0:3>: <forestry:planks.fireproof.0:3>,
    <forestry:logs.fireproof.1:0>: <forestry:planks.fireproof.0:4>,
    <forestry:logs.fireproof.1:1>: <forestry:planks.fireproof.0:5>,
    <forestry:logs.fireproof.1:2>: <forestry:planks.fireproof.0:6>,
    <forestry:logs.fireproof.1:3>: <forestry:planks.fireproof.0:7>,
    <forestry:logs.fireproof.2:0>: <forestry:planks.fireproof.0:8>,
    <forestry:logs.fireproof.2:1>: <forestry:planks.fireproof.0:9>,
    <forestry:logs.fireproof.2:2>: <forestry:planks.fireproof.0:10>,
    <forestry:logs.fireproof.2:3>: <forestry:planks.fireproof.0:11>,
    <forestry:logs.fireproof.3:0>: <forestry:planks.fireproof.0:12>,
    <forestry:logs.fireproof.3:1>: <forestry:planks.fireproof.0:13>,
    <forestry:logs.fireproof.3:2>: <forestry:planks.fireproof.0:14>,
    <forestry:logs.fireproof.3:3>: <forestry:planks.fireproof.0:15>,
    <forestry:logs.fireproof.4:0>: <forestry:planks.fireproof.1:0>,
    <forestry:logs.fireproof.4:1>: <forestry:planks.fireproof.1:1>,
    <forestry:logs.fireproof.4:2>: <forestry:planks.fireproof.1:2>,
    <forestry:logs.fireproof.4:3>: <forestry:planks.fireproof.1:3>,
    <forestry:logs.fireproof.5:0>: <forestry:planks.fireproof.1:4>,
    <forestry:logs.fireproof.5:1>: <forestry:planks.fireproof.1:5>,
    <forestry:logs.fireproof.5:2>: <forestry:planks.fireproof.1:6>,
    <forestry:logs.fireproof.5:3>: <forestry:planks.fireproof.1:7>,
    <forestry:logs.fireproof.6:0>: <forestry:planks.fireproof.1:8>,
    <forestry:logs.fireproof.6:1>: <forestry:planks.fireproof.1:9>,
    <forestry:logs.fireproof.6:2>: <forestry:planks.fireproof.1:10>,
    <forestry:logs.fireproof.6:3>: <forestry:planks.fireproof.1:11>,
    <forestry:logs.fireproof.7:0>: <forestry:planks.fireproof.1:12>,
    <extratrees:logs.0:0>: <extratrees:planks.0:0>,
    <extratrees:logs.0:1>: <extratrees:planks.0:1>,
    <extratrees:logs.0:2>: <extratrees:planks.0:2>,
    <extratrees:logs.0:3>: <extratrees:planks.0:3>,
    <extratrees:logs.1:0>: <extratrees:planks.0:4>,
    <extratrees:logs.1:1>: <extratrees:planks.0:5>,
    <extratrees:logs.1:2>: <extratrees:planks.0:6>,
    <extratrees:logs.1:3>: <extratrees:planks.0:7>,
    <extratrees:logs.2:0>: <extratrees:planks.0:8>,
    <extratrees:logs.2:1>: <extratrees:planks.0:9>,
    <extratrees:logs.2:2>: <extratrees:planks.0:10>,
    <extratrees:logs.2:3>: <extratrees:planks.0:11>,
    <extratrees:logs.3:0>: <extratrees:planks.0:12>,
    <extratrees:logs.3:1>: <extratrees:planks.0:13>,
    <extratrees:logs.3:2>: <extratrees:planks.0:14>,
    <extratrees:logs.3:3>: <extratrees:planks.0:15>,
    <extratrees:logs.4:0>: <extratrees:planks.1:0>,
    <extratrees:logs.4:1>: <extratrees:planks.1:1>,
    <extratrees:logs.4:2>: <extratrees:planks.1:2>,
    <extratrees:logs.4:3>: <extratrees:planks.1:3>,
    <extratrees:logs.5:0>: <extratrees:planks.1:4>,
    <extratrees:logs.5:1>: <extratrees:planks.1:5>,
    <extratrees:logs.5:2>: <extratrees:planks.1:6>,
    <extratrees:logs.5:3>: <extratrees:planks.1:7>,
    <extratrees:logs.6:0>: <extratrees:planks.1:8>,
    <extratrees:logs.6:1>: <extratrees:planks.1:9>,
    <extratrees:logs.6:2>: <extratrees:planks.1:10>,
    <extratrees:logs.6:3>: <extratrees:planks.1:11>,
    <extratrees:logs.7:0>: <extratrees:planks.1:12>,
    <extratrees:logs.7:1>: <extratrees:planks.1:13>,
    <extratrees:logs.7:2>: <extratrees:planks.1:14>,
    <extratrees:logs.7:3>: <extratrees:planks.1:15>,
    <extratrees:logs.8:1>: <extratrees:planks.2:1>,
    <extratrees:logs.8:2>: <extratrees:planks.2:2>,
    <extratrees:logs.8:3>: <extratrees:planks.2:3>,
    <extratrees:logs.9:1>: <extratrees:planks.2:0>,
    <extratrees:logs.9:2>: <forestry:planks.0:15>,
    <extratrees:logs.9:3>: <minecraft:planks:3>,
    <extratrees:logs.fireproof.0:0>: <extratrees:planks.fireproof.0:0>,
    <extratrees:logs.fireproof.0:1>: <extratrees:planks.fireproof.0:1>,
    <extratrees:logs.fireproof.0:2>: <extratrees:planks.fireproof.0:2>,
    <extratrees:logs.fireproof.0:3>: <extratrees:planks.fireproof.0:3>,
    <extratrees:logs.fireproof.1:0>: <extratrees:planks.fireproof.0:4>,
    <extratrees:logs.fireproof.1:1>: <extratrees:planks.fireproof.0:5>,
    <extratrees:logs.fireproof.1:2>: <extratrees:planks.fireproof.0:6>,
    <extratrees:logs.fireproof.1:3>: <extratrees:planks.fireproof.0:7>,
    <extratrees:logs.fireproof.2:0>: <extratrees:planks.fireproof.0:8>,
    <extratrees:logs.fireproof.2:1>: <extratrees:planks.fireproof.0:9>,
    <extratrees:logs.fireproof.2:2>: <extratrees:planks.fireproof.0:10>,
    <extratrees:logs.fireproof.2:3>: <extratrees:planks.fireproof.0:11>,
    <extratrees:logs.fireproof.3:0>: <extratrees:planks.fireproof.0:12>,
    <extratrees:logs.fireproof.3:1>: <extratrees:planks.fireproof.0:13>,
    <extratrees:logs.fireproof.3:2>: <extratrees:planks.fireproof.0:14>,
    <extratrees:logs.fireproof.3:3>: <extratrees:planks.fireproof.0:15>,
    <extratrees:logs.fireproof.4:0>: <extratrees:planks.fireproof.1:0>,
    <extratrees:logs.fireproof.4:1>: <extratrees:planks.fireproof.1:1>,
    <extratrees:logs.fireproof.4:2>: <extratrees:planks.fireproof.1:2>,
    <extratrees:logs.fireproof.4:3>: <extratrees:planks.fireproof.1:3>,
    <extratrees:logs.fireproof.5:0>: <extratrees:planks.fireproof.1:4>,
    <extratrees:logs.fireproof.5:1>: <extratrees:planks.fireproof.1:5>,
    <extratrees:logs.fireproof.5:2>: <extratrees:planks.fireproof.1:6>,
    <extratrees:logs.fireproof.5:3>: <extratrees:planks.fireproof.1:7>,
    <extratrees:logs.fireproof.6:0>: <extratrees:planks.fireproof.1:8>,
    <extratrees:logs.fireproof.6:1>: <extratrees:planks.fireproof.1:9>,
    <extratrees:logs.fireproof.6:2>: <extratrees:planks.fireproof.1:10>,
    <extratrees:logs.fireproof.6:3>: <extratrees:planks.fireproof.1:11>,
    <extratrees:logs.fireproof.7:0>: <extratrees:planks.fireproof.1:12>,
    <extratrees:logs.fireproof.7:1>: <extratrees:planks.fireproof.1:13>,
    <extratrees:logs.fireproof.7:2>: <extratrees:planks.fireproof.1:14>,
    <extratrees:logs.fireproof.7:3>: <extratrees:planks.fireproof.1:15>,
    <extratrees:logs.fireproof.8:1>: <extratrees:planks.fireproof.2:1>,
    <extratrees:logs.fireproof.8:2>: <extratrees:planks.fireproof.2:2>,
    <extratrees:logs.fireproof.8:3>: <extratrees:planks.fireproof.2:3>,
    <extratrees:logs.fireproof.9:1>: <extratrees:planks.fireproof.2:0>,
    <extratrees:logs.fireproof.9:2>: <forestry:planks.fireproof.0:15>,
    <extratrees:logs.fireproof.9:3>: <forestry:planks.vanilla.fireproof.0:3>,
    <extratrees:planks.0:0>: <extratrees:slabs.0:0>,
    <extratrees:planks.0:1>: <extratrees:slabs.0:1>,
    <extratrees:planks.0:10>: <extratrees:slabs.1:2>,
    <extratrees:planks.0:11>: <extratrees:slabs.1:3>,
    <extratrees:planks.0:12>: <extratrees:slabs.1:4>,
    <extratrees:planks.0:13>: <extratrees:slabs.1:5>,
    <extratrees:planks.0:14>: <extratrees:slabs.1:6>,
    <extratrees:planks.0:15>: <extratrees:slabs.1:7>,
    <extratrees:planks.0:2>: <extratrees:slabs.0:2>,
    <extratrees:planks.0:3>: <extratrees:slabs.0:3>,
    <extratrees:planks.0:4>: <extratrees:slabs.0:4>,
    <extratrees:planks.0:5>: <extratrees:slabs.0:5>,
    <extratrees:planks.0:6>: <extratrees:slabs.0:6>,
    <extratrees:planks.0:7>: <extratrees:slabs.0:7>,
    <extratrees:planks.0:8>: <extratrees:slabs.1:0>,
    <extratrees:planks.0:9>: <extratrees:slabs.1:1>,
    <extratrees:planks.1:0>: <extratrees:slabs.2:0>,
    <extratrees:planks.1:1>: <extratrees:slabs.2:1>,
    <extratrees:planks.1:10>: <extratrees:slabs.3:2>,
    <extratrees:planks.1:11>: <extratrees:slabs.3:3>,
    <extratrees:planks.1:12>: <extratrees:slabs.3:4>,
    <extratrees:planks.1:13>: <extratrees:slabs.3:5>,
    <extratrees:planks.1:14>: <extratrees:slabs.3:6>,
    <extratrees:planks.1:15>: <extratrees:slabs.3:7>,
    <extratrees:planks.1:2>: <extratrees:slabs.2:2>,
    <extratrees:planks.1:3>: <extratrees:slabs.2:3>,
    <extratrees:planks.1:4>: <extratrees:slabs.2:4>,
    <extratrees:planks.1:5>: <extratrees:slabs.2:5>,
    <extratrees:planks.1:6>: <extratrees:slabs.2:6>,
    <extratrees:planks.1:7>: <extratrees:slabs.2:7>,
    <extratrees:planks.1:8>: <extratrees:slabs.3:0>,
    <extratrees:planks.1:9>: <extratrees:slabs.3:1>,
    <extratrees:planks.2:0>: <extratrees:slabs.4:0>,
    <extratrees:planks.2:1>: <extratrees:slabs.4:1>,
    <extratrees:planks.2:2>: <extratrees:slabs.4:2>,
    <extratrees:planks.2:3>: <extratrees:slabs.4:3>,
    <extratrees:planks.fireproof.0:0>: <extratrees:slabs.fireproof.0:0>,
    <extratrees:planks.fireproof.0:1>: <extratrees:slabs.fireproof.0:1>,
    <extratrees:planks.fireproof.0:10>: <extratrees:slabs.fireproof.1:2>,
    <extratrees:planks.fireproof.0:11>: <extratrees:slabs.fireproof.1:3>,
    <extratrees:planks.fireproof.0:12>: <extratrees:slabs.fireproof.1:4>,
    <extratrees:planks.fireproof.0:13>: <extratrees:slabs.fireproof.1:5>,
    <extratrees:planks.fireproof.0:14>: <extratrees:slabs.fireproof.1:6>,
    <extratrees:planks.fireproof.0:15>: <extratrees:slabs.fireproof.1:7>,
    <extratrees:planks.fireproof.0:2>: <extratrees:slabs.fireproof.0:2>,
    <extratrees:planks.fireproof.0:3>: <extratrees:slabs.fireproof.0:3>,
    <extratrees:planks.fireproof.0:4>: <extratrees:slabs.fireproof.0:4>,
    <extratrees:planks.fireproof.0:5>: <extratrees:slabs.fireproof.0:5>,
    <extratrees:planks.fireproof.0:6>: <extratrees:slabs.fireproof.0:6>,
    <extratrees:planks.fireproof.0:7>: <extratrees:slabs.fireproof.0:7>,
    <extratrees:planks.fireproof.0:8>: <extratrees:slabs.fireproof.1:0>,
    <extratrees:planks.fireproof.0:9>: <extratrees:slabs.fireproof.1:1>,
    <extratrees:planks.fireproof.1:0>: <extratrees:slabs.fireproof.2:0>,
    <extratrees:planks.fireproof.1:1>: <extratrees:slabs.fireproof.2:1>,
    <extratrees:planks.fireproof.1:10>: <extratrees:slabs.fireproof.3:2>,
    <extratrees:planks.fireproof.1:11>: <extratrees:slabs.fireproof.3:3>,
    <extratrees:planks.fireproof.1:12>: <extratrees:slabs.fireproof.3:4>,
    <extratrees:planks.fireproof.1:13>: <extratrees:slabs.fireproof.3:5>,
    <extratrees:planks.fireproof.1:14>: <extratrees:slabs.fireproof.3:6>,
    <extratrees:planks.fireproof.1:15>: <extratrees:slabs.fireproof.3:7>,
    <extratrees:planks.fireproof.1:2>: <extratrees:slabs.fireproof.2:2>,
    <extratrees:planks.fireproof.1:3>: <extratrees:slabs.fireproof.2:3>,
    <extratrees:planks.fireproof.1:4>: <extratrees:slabs.fireproof.2:4>,
    <extratrees:planks.fireproof.1:5>: <extratrees:slabs.fireproof.2:5>,
    <extratrees:planks.fireproof.1:6>: <extratrees:slabs.fireproof.2:6>,
    <extratrees:planks.fireproof.1:7>: <extratrees:slabs.fireproof.2:7>,
    <extratrees:planks.fireproof.1:8>: <extratrees:slabs.fireproof.3:0>,
    <extratrees:planks.fireproof.1:9>: <extratrees:slabs.fireproof.3:1>,
    <extratrees:planks.fireproof.2:0>: <extratrees:slabs.fireproof.4:0>,
    <extratrees:planks.fireproof.2:1>: <extratrees:slabs.fireproof.4:1>,
    <extratrees:planks.fireproof.2:2>: <extratrees:slabs.fireproof.4:2>,
    <extratrees:planks.fireproof.2:3>: <extratrees:slabs.fireproof.4:3>,
    <forestry:logs.vanilla.fireproof.0:0>: <forestry:planks.vanilla.fireproof.0:0>,
    <forestry:logs.vanilla.fireproof.0:1>: <forestry:planks.vanilla.fireproof.0:1>,
    <forestry:logs.vanilla.fireproof.0:2>: <forestry:planks.vanilla.fireproof.0:2>,
    <forestry:logs.vanilla.fireproof.0:3>: <forestry:planks.vanilla.fireproof.0:3>,
    <forestry:logs.vanilla.fireproof.1:0>: <forestry:planks.vanilla.fireproof.0:4>,
    <forestry:logs.vanilla.fireproof.1:1>: <forestry:planks.vanilla.fireproof.0:5>,
    //<plants2:crystal_log:0>: <plants2:crystal_planks:0>,
    //<plants2:crystal_log:1>: <plants2:crystal_planks:1>,
    //<plants2:log_0:0>: <plants2:planks:2>,
    //<plants2:log_0:1>: <plants2:planks:3>,
    //<plants2:log_0:2>: <plants2:planks:4>,
    //<plants2:log_0:3>: <plants2:planks:5>,
    //<plants2:nether_log:0>: <plants2:planks:0>,
    //<plants2:nether_log:1>: <plants2:planks:1>,
    <traverse:fir_log:0>: <traverse:fir_planks:0>,
    //<advancedrocketry:alienwood:0>: <advancedrocketry:planks:0>,
    <roots:wildwood_log:0>: <roots:wildwood_planks:0>,
    <mysticalworld:charred_log:0>: <mysticalworld:charred_planks:0>,
    <natura:nether_logs:0>: <natura:nether_planks:0>,
    <natura:nether_logs:1>: <natura:nether_planks:2>,
    <natura:nether_logs:2>: <natura:nether_planks:3>,
    <natura:overworld_logs2:0>: <natura:overworld_planks:4>,
    <natura:overworld_logs2:1>: <natura:overworld_planks:5>,
    <natura:overworld_logs2:2>: <natura:overworld_planks:6>,
    <natura:overworld_logs2:3>: <natura:overworld_planks:7>,
    <natura:overworld_logs:0>: <natura:overworld_planks:0>,
    <natura:overworld_logs:1>: <natura:overworld_planks:1>,
    <natura:overworld_logs:2>: <natura:overworld_planks:2>,
    <natura:overworld_logs:3>: <natura:overworld_planks:3>,
    <natura:redwood_logs:1>: <natura:overworld_planks:8>,
    <totemic:cedar_log:0>: <totemic:cedar_plank:0>,
    <fossil:calamites_log:0>: <fossil:calamites_planks:0>,
    <fossil:cordaites_log:0>: <fossil:cordaites_planks:0>,
    <fossil:palm_log:0>: <fossil:palm_planks:0>,
    <fossil:sigillaria_log:0>: <fossil:sigillaria_planks:0>,
    <twilightforest:twilight_log>: <twilightforest:twilight_oak_planks>,
    <twilightforest:twilight_log:1>: <twilightforest:canopy_planks>,
    <twilightforest:twilight_log:2>: <twilightforest:mangrove_planks>,
    <twilightforest:twilight_log:3>: <twilightforest:dark_planks>,
    <twilightforest:magic_log>: <twilightforest:time_planks>,
    <twilightforest:magic_log:1>: <twilightforest:trans_planks>,
    <twilightforest:magic_log:2>: <twilightforest:mine_planks>,
    <twilightforest:magic_log:3>: <twilightforest:sort_planks>,
    <astralsorcery:blockinfusedwood>: <astralsorcery:blockinfusedwood:1>,
    <abyssalcraft:dltlog:0>: <abyssalcraft:dltplank:0>,
    <abyssalcraft:dreadlog:0>: <abyssalcraft:dreadplanks:0>,
    <botania:livingwood>: <botania:livingwood:1>,
    <botania:dreamwood>: <botania:dreamwood:1>,
    <natura:nether_logs2>: <natura:nether_planks:1>,
    <evilcraft:undead_log:0>: <evilcraft:undead_plank:0>,
    <stygian:endlog:0>: <stygian:endplanks:0>,
    <thaumcraft:log_greatwood:0>: <thaumcraft:plank_greatwood:0>,
    <thaumcraft:log_silverwood:0>: <thaumcraft:plank_silverwood:0>,
    <thaumcraft:plank_greatwood:0>: <thaumcraft:slab_greatwood:0>,
    <thaumcraft:plank_silverwood:0>: <thaumcraft:slab_silverwood:0>,
    <randomthings:spectrelog:0>: <randomthings:spectreplank:0>,
    <extrautils2:decorativesolidwood:1>: <extrautils2:decorativesolidwood>
    };
for IItemStack, IIngredient in Woods {
        recipes.remove(IIngredient);


		saw.recipeBuilder()
			.inputs(IItemStack)
			.outputs(IIngredient * 6)
            .outputs(<ore:dustWood>.firstItem * 2)   
			.duration(200)
			.EUt(8)
		.buildAndRegister();

        mods.advancedrocketry.CuttingMachine.addRecipe(IIngredient*8, 180/*ticks*/, 800/*rf/t*/, IItemStack);

}


var PlanksToSlabs as IItemStack[IIngredient] = {
    <mysticalworld:charred_planks:0>: <mysticalworld:charred_slab:0>,
    <roots:wildwood_planks:0>: <roots:wildwood_slab:0>,
    //<plants2:planks:0>: <plants2:ash_slab:0>,
    //<plants2:planks:1>: <plants2:blaze_slab:0>,
    //<plants2:planks:2>: <plants2:black_kauri_slab:0>,
    //<plants2:planks:3>: <plants2:brazillian_pine_slab:0>,
    //<plants2:planks:4>: <plants2:incense_cedar_slab:0>,
    //<plants2:planks:5>: <plants2:murray_pine_slab:0>,
    <traverse:fir_planks:0>: <traverse:fir_slab:0>,
    //<plants2:crystal_planks:0>: <plants2:crystal_slab:0>,
    //<plants2:crystal_planks:1>: <plants2:dark_crystal_slab:0>,
    <forestry:planks.0:0>: <forestry:slabs.0:0>,
    <forestry:planks.0:1>: <forestry:slabs.0:1>,
    <forestry:planks.0:10>: <forestry:slabs.1:2>,
    <forestry:planks.0:11>: <forestry:slabs.1:3>,
    <forestry:planks.0:12>: <forestry:slabs.1:4>,
    <forestry:planks.0:13>: <forestry:slabs.1:5>,
    <forestry:planks.0:14>: <forestry:slabs.1:6>,
    <forestry:planks.0:15>: <forestry:slabs.1:7>,
    <forestry:planks.0:2>: <forestry:slabs.0:2>,
    <forestry:planks.0:3>: <forestry:slabs.0:3>,
    <forestry:planks.0:4>: <forestry:slabs.0:4>,
    <forestry:planks.0:5>: <forestry:slabs.0:5>,
    <forestry:planks.0:6>: <forestry:slabs.0:6>,
    <forestry:planks.0:7>: <forestry:slabs.0:7>,
    <forestry:planks.0:8>: <forestry:slabs.1:0>,
    <forestry:planks.0:9>: <forestry:slabs.1:1>,
    <forestry:planks.1:0>: <forestry:slabs.2:0>,
    <forestry:planks.1:1>: <forestry:slabs.2:1>,
    <forestry:planks.1:10>: <forestry:slabs.3:2>,
    <forestry:planks.1:11>: <forestry:slabs.3:3>,
    <forestry:planks.1:12>: <forestry:slabs.3:4>,
    <forestry:planks.1:2>: <forestry:slabs.2:2>,
    <forestry:planks.1:3>: <forestry:slabs.2:3>,
    <forestry:planks.1:4>: <forestry:slabs.2:4>,
    <forestry:planks.1:5>: <forestry:slabs.2:5>,
    <forestry:planks.1:6>: <forestry:slabs.2:6>,
    <forestry:planks.1:7>: <forestry:slabs.2:7>,
    <forestry:planks.1:8>: <forestry:slabs.3:0>,
    <forestry:planks.1:9>: <forestry:slabs.3:1>,
    <forestry:planks.fireproof.0:0>: <forestry:slabs.fireproof.0:0>,
    <forestry:planks.fireproof.0:1>: <forestry:slabs.fireproof.0:1>,
    <forestry:planks.fireproof.0:10>: <forestry:slabs.fireproof.1:2>,
    <forestry:planks.fireproof.0:11>: <forestry:slabs.fireproof.1:3>,
    <forestry:planks.fireproof.0:12>: <forestry:slabs.fireproof.1:4>,
    <forestry:planks.fireproof.0:13>: <forestry:slabs.fireproof.1:5>,
    <forestry:planks.fireproof.0:14>: <forestry:slabs.fireproof.1:6>,
    <forestry:planks.fireproof.0:15>: <forestry:slabs.fireproof.1:7>,
    <forestry:planks.fireproof.0:3>: <forestry:slabs.fireproof.0:3>,
    <forestry:planks.fireproof.0:4>: <forestry:slabs.fireproof.0:4>,
    <forestry:planks.fireproof.0:5>: <forestry:slabs.fireproof.0:5>,
    <forestry:planks.fireproof.0:6>: <forestry:slabs.fireproof.0:6>,
    <forestry:planks.fireproof.0:7>: <forestry:slabs.fireproof.0:7>,
    <forestry:planks.fireproof.0:8>: <forestry:slabs.fireproof.1:0>,
    <forestry:planks.fireproof.0:9>: <forestry:slabs.fireproof.1:1>,
    <forestry:planks.fireproof.1:0>: <forestry:slabs.fireproof.2:0>,
    <forestry:planks.fireproof.1:1>: <forestry:slabs.fireproof.2:1>,
    <forestry:planks.fireproof.1:10>: <forestry:slabs.fireproof.3:2>,
    <forestry:planks.fireproof.1:11>: <forestry:slabs.fireproof.3:3>,
    <forestry:planks.fireproof.1:12>: <forestry:slabs.fireproof.3:4>,
    <forestry:planks.fireproof.1:2>: <forestry:slabs.fireproof.2:2>,
    <forestry:planks.fireproof.1:3>: <forestry:slabs.fireproof.2:3>,
    <forestry:planks.fireproof.1:4>: <forestry:slabs.fireproof.2:4>,
    <forestry:planks.fireproof.1:5>: <forestry:slabs.fireproof.2:5>,
    <forestry:planks.fireproof.1:6>: <forestry:slabs.fireproof.2:6>,
    <forestry:planks.fireproof.1:7>: <forestry:slabs.fireproof.2:7>,
    <forestry:planks.fireproof.1:8>: <forestry:slabs.fireproof.3:0>,
    <forestry:planks.fireproof.1:9>: <forestry:slabs.fireproof.3:1>,
    <forestry:planks.vanilla.fireproof.0:0>: <forestry:slabs.vanilla.fireproof.0:0>,
    <forestry:planks.vanilla.fireproof.0:1>: <forestry:slabs.vanilla.fireproof.0:1>,
    <forestry:planks.vanilla.fireproof.0:2>: <forestry:slabs.vanilla.fireproof.0:2>,
    <forestry:planks.vanilla.fireproof.0:3>: <forestry:slabs.vanilla.fireproof.0:3>,
    <forestry:planks.vanilla.fireproof.0:4>: <forestry:slabs.vanilla.fireproof.0:4>,
    <forestry:planks.vanilla.fireproof.0:5>: <forestry:slabs.vanilla.fireproof.0:5>,
    //<rustic:planks:0>: <rustic:olive_slab_item:0>,
    //<rustic:planks:1>: <rustic:ironwood_slab_item:0>,
    <biomesoplenty:planks_0:0>: <biomesoplenty:wood_slab_0:0>,
    <biomesoplenty:planks_0:1>: <biomesoplenty:wood_slab_0:1>,
    <biomesoplenty:planks_0:10>: <biomesoplenty:wood_slab_1:2>,
    <biomesoplenty:planks_0:11>: <biomesoplenty:wood_slab_1:3>,
    <biomesoplenty:planks_0:12>: <biomesoplenty:wood_slab_1:4>,
    <biomesoplenty:planks_0:13>: <biomesoplenty:wood_slab_1:5>,
    <biomesoplenty:planks_0:14>: <biomesoplenty:wood_slab_1:6>,
    <biomesoplenty:planks_0:15>: <biomesoplenty:wood_slab_1:7>,
    <biomesoplenty:planks_0:2>: <biomesoplenty:wood_slab_0:2>,
    <biomesoplenty:planks_0:3>: <biomesoplenty:wood_slab_0:3>,
    <biomesoplenty:planks_0:4>: <biomesoplenty:wood_slab_0:4>,
    <biomesoplenty:planks_0:5>: <biomesoplenty:wood_slab_0:5>,
    <biomesoplenty:planks_0:6>: <biomesoplenty:wood_slab_0:6>,
    <biomesoplenty:planks_0:7>: <biomesoplenty:wood_slab_0:7>,
    <biomesoplenty:planks_0:8>: <biomesoplenty:wood_slab_1:0>,
    <biomesoplenty:planks_0:9>: <biomesoplenty:wood_slab_1:1>,
    <minecraft:planks:0>: <minecraft:wooden_slab:0>,
    <minecraft:planks:1>: <minecraft:wooden_slab:1>,
    <minecraft:planks:2>: <minecraft:wooden_slab:2>,
    <minecraft:planks:3>: <minecraft:wooden_slab:3>,
    <minecraft:planks:4>: <minecraft:wooden_slab:4>,
    <minecraft:planks:5>: <minecraft:wooden_slab:5>,
    //<quark:stained_planks> : <quark:stained_planks_white_slab>,
    //<quark:stained_planks:1> : <quark:stained_planks_orange_slab>,
    //<quark:stained_planks:2> : <quark:stained_planks_magenta_slab>,
    //<quark:stained_planks:3> : <quark:stained_planks_light_blue_slab>,
    //<quark:stained_planks:4> : <quark:stained_planks_yellow_slab>,
    //<quark:stained_planks:5> : <quark:stained_planks_lime_slab>,
    //<quark:stained_planks:6> : <quark:stained_planks_pink_slab>,
    //<quark:stained_planks:7> : <quark:stained_planks_gray_slab>,
    //<quark:stained_planks:8> : <quark:stained_planks_silver_slab>,
    //<quark:stained_planks:9> : <quark:stained_planks_cyan_slab>,   
    //<quark:stained_planks:10> : <quark:stained_planks_purple_slab>,
    //<quark:stained_planks:11> : <quark:stained_planks_blue_slab>,
    //<quark:stained_planks:12> : <quark:stained_planks_brown_slab>,
    //<quark:stained_planks:13> : <quark:stained_planks_green_slab>,
    //<quark:stained_planks:14> : <quark:stained_planks_red_slab>,
    //<quark:stained_planks:15> : <quark:stained_planks_black_slab>,
    <natura:nether_planks:0>: <natura:nether_slab:0>,
    <natura:nether_planks:1>: <natura:nether_slab:1>,
    <natura:nether_planks:2>: <natura:nether_slab:2>,
    <natura:nether_planks:3>: <natura:nether_slab:3>,
    <natura:overworld_planks:0>: <natura:overworld_slab:0>,
    <natura:overworld_planks:1>: <natura:overworld_slab:1>,
    <natura:overworld_planks:2>: <natura:overworld_slab:2>,
    <natura:overworld_planks:3>: <natura:overworld_slab:3>,
    <natura:overworld_planks:4>: <natura:overworld_slab:4>,
    <natura:overworld_planks:5>: <natura:overworld_slab2:0>,
    <natura:overworld_planks:6>: <natura:overworld_slab2:1>,
    <natura:overworld_planks:7>: <natura:overworld_slab2:2>,
    <natura:overworld_planks:8>: <natura:overworld_slab2:3>,
    <totemic:cedar_plank:0>: <totemic:cedar_slab:0>,
    <fossil:calamites_planks:0>: <fossil:calamites_planks_slab:0>,
    <fossil:cordaites_planks:0>: <fossil:cordaites_planks_slab:0>,
    <fossil:palm_planks:0>: <fossil:palm_planks_slab:0>,
    <fossil:sigillaria_planks:0>: <fossil:sigillaria_planks_slab:0>,
    <fossil:ancient_wood>: <fossil:ancient_wood_slab>,
    <twilightforest:twilight_oak_planks>: <twilightforest:twilight_oak_slab>,
    <twilightforest:canopy_planks>: <twilightforest:canopy_slab>,
    <twilightforest:mangrove_planks>: <twilightforest:mangrove_slab>,
    <twilightforest:dark_planks>: <twilightforest:dark_slab>,
    <twilightforest:time_planks>: <twilightforest:time_slab>,
    <twilightforest:trans_planks>: <twilightforest:trans_slab>,
    <twilightforest:mine_planks>: <twilightforest:mine_slab>,
    <twilightforest:sort_planks>: <twilightforest:sort_slab>,
    <abyssalcraft:dltplank:0>: <abyssalcraft:dltslab1:0>,
    <botania:livingwood:1>: <botania:livingwood1slab>,
    <botania:dreamwood:1>: <botania:dreamwood1slab>
    };
for IItemStack, IIngredient in PlanksToSlabs {
        recipes.remove(IIngredient);

		saw.recipeBuilder()
			.inputs(IItemStack)
			.outputs(IIngredient * 2)
            .outputs(<ore:dustWood>.firstItem * 1)   
			.duration(50)
			.EUt(8)
		.buildAndRegister();

        mods.advancedrocketry.CuttingMachine.addRecipe(IIngredient*4, 100/*ticks*/, 800/*rf/t*/, IItemStack);

}


//Removing Astral Sorcery Marble Slab Recipe
Altar.removeAltarRecipe("astralsorcery:shaped/marble_slab");

var NonWoodSlabs as IItemStack[IIngredient] = {

    <appliedenergistics2:fluix_block> : <appliedenergistics2:fluix_slab>,
    //<immersiveengineering:treated_wood> : <immersiveengineering:treated_wood_slab>,
    //<minecraft:red_sandstone> : <minecraft:stone_slab2>,
    //<minecraft:purpur_block> : <minecraft:purpur_slab>,
    <actuallyadditions:block_testifi_bucks_green_wall> : <actuallyadditions:block_testifi_bucks_green_slab>,
    <actuallyadditions:block_testifi_bucks_white_wall> : <actuallyadditions:block_testifi_bucks_white_slab>,        
    <actuallyadditions:block_misc:2> : <actuallyadditions:block_quartz_slab>,        
    <actuallyadditions:block_misc:1> : <actuallyadditions:block_chiseled_quartz_slab>,        
    <actuallyadditions:block_misc> : <actuallyadditions:block_pillar_quartz_slab>,        
    <appliedenergistics2:sky_stone_block> : <appliedenergistics2:sky_stone_slab>,        
    <appliedenergistics2:smooth_sky_stone_block> : <appliedenergistics2:smooth_sky_stone_slab>,        
    <appliedenergistics2:sky_stone_brick> : <appliedenergistics2:sky_stone_brick_slab>,        
    <appliedenergistics2:sky_stone_small_brick> : <appliedenergistics2:sky_stone_small_brick_slab>,        
    <appliedenergistics2:quartz_block> : <appliedenergistics2:quartz_slab>,        
    <appliedenergistics2:chiseled_quartz_block> : <appliedenergistics2:chiseled_quartz_slab>,        
    <appliedenergistics2:quartz_pillar> : <appliedenergistics2:quartz_pillar_slab>,        
    <biomesoplenty:mud_brick_block> : <biomesoplenty:other_slab>,        
    <biomesoplenty:white_sandstone> : <biomesoplenty:other_slab:1>,        
    //<engineersdecor:clinker_brick_block> : <engineersdecor:clinker_brick_slab>,
    //<engineersdecor:clinker_brick_stained_block> : <engineersdecor:clinker_brick_stained_slab>,
    //<engineersdecor:slag_brick_block> : <engineersdecor:slag_brick_slab>,
    //<engineersdecor:rebar_concrete> : <engineersdecor:rebar_concrete_slab>,
    //<engineersdecor:rebar_concrete_tile> : <engineersdecor:rebar_concrete_tile_slab>,
    //<engineersdecor:gas_concrete> : <engineersdecor:gas_concrete_slab>,        
    //<immersiveengineering:stone_decoration:2> : <immersiveengineering:stone_decoration_slab:2>,
    //<immersiveengineering:stone_decoration:4> : <immersiveengineering:stone_decoration_slab:4>,
    //<immersiveengineering:stone_decoration:5> : <immersiveengineering:stone_decoration_slab:5>,
    //<immersiveengineering:stone_decoration:6> : <immersiveengineering:stone_decoration_slab:6>,
    //<immersiveengineering:stone_decoration:7> : <immersiveengineering:stone_decoration_slab:7>,
    //<immersiveengineering:stone_decoration:10> : <immersiveengineering:stone_decoration_slab:10>,
    //<immersiveengineering:treated_wood:1> : <immersiveengineering:treated_wood_slab:1>,
    //<immersiveengineering:treated_wood:2> : <immersiveengineering:treated_wood_slab:2>,
    //<immersiveengineering:sheetmetal> : <immersiveengineering:sheetmetal_slab>,
    //<immersiveengineering:sheetmetal:1> : <immersiveengineering:sheetmetal_slab:1>,
    //<immersiveengineering:sheetmetal:2> : <immersiveengineering:sheetmetal_slab:2>,
    //<immersiveengineering:sheetmetal:3> : <immersiveengineering:sheetmetal_slab:3>, 
    //<immersiveengineering:sheetmetal:4> : <immersiveengineering:sheetmetal_slab:4>, 
    //<immersiveengineering:sheetmetal:5> : <immersiveengineering:sheetmetal_slab:5>, 
    //<immersiveengineering:sheetmetal:6> : <immersiveengineering:sheetmetal_slab:6>, 
    //<immersiveengineering:sheetmetal:7> : <immersiveengineering:sheetmetal_slab:7>, 
    //<immersiveengineering:sheetmetal:8> : <immersiveengineering:sheetmetal_slab:8>, 
    //<immersiveengineering:sheetmetal:9> : <immersiveengineering:sheetmetal_slab:9>, 
    //<immersiveengineering:sheetmetal:10> : <immersiveengineering:sheetmetal_slab:10>, 
    //<immersiveengineering:metal_decoration1:1> : <immersiveengineering:metal_decoration1_slab:1>,
    //<immersiveengineering:metal_decoration1:2> : <immersiveengineering:metal_decoration1_slab:2>,
    //<immersiveengineering:metal_decoration1:3> : <immersiveengineering:metal_decoration1_slab:3>,
    //<immersiveengineering:metal_decoration1:5> : <immersiveengineering:metal_decoration1_slab:5>,
    //<immersiveengineering:metal_decoration1:6> : <immersiveengineering:metal_decoration1_slab:6>,
    //<immersiveengineering:metal_decoration1:7> : <immersiveengineering:metal_decoration1_slab:7>,
    //<immersivetech:stone_decoration> : <immersivetech:stone_decoration_slab>,        
    <mysticalworld:thatch> : <mysticalworld:thatch_slab>,        
    <mysticalworld:mud_block> : <mysticalworld:mud_block_slab>,        
    <mysticalworld:mud_brick> : <mysticalworld:mud_brick_slab>,        
    <mysticalworld:pearl_block> : <mysticalworld:pearl_slab>,              
    //<quark:basalt> : <quark:stone_basalt_slab>,        
    //<quark:marble> : <quark:stone_marble_slab>,        
    //<quark:limestone> : <quark:stone_limestone_slab>,        
    <quark:jasper> : <quark:stone_jasper_slab>,        
    <quark:slate> : <quark:stone_slate_slab>,        
    <quark:biome_cobblestone> : <quark:fire_stone_slab>,        
    <quark:biome_brick> : <quark:fire_stone_brick_slab>,        
    <quark:biome_cobblestone:1> : <quark:icy_stone_slab>,        
    <quark:biome_brick:1> : <quark:icy_stone_brick_slab>,        
    <quark:biome_cobblestone:2> : <quark:cobbed_stone_slab>,        
    <quark:elder_prismarine> : <quark:elder_prismarine_slab>,        
    <quark:elder_prismarine:1> : <quark:elder_prismarine_bricks_slab>,        
    <quark:elder_prismarine:2> : <quark:elder_prismarine_dark_slab>,        
    <quark:sandstone_new> : <quark:sandstone_smooth_slab>,        
    <quark:sandstone_new:1> : <quark:sandstone_bricks_slab>,        
    <quark:sandstone_new:2> : <quark:red_sandstone_smooth_slab>,        
    <quark:sandstone_new:3> : <quark:red_sandstone_bricks_slab>,        
    <quark:sandstone_new:4> : <quark:soul_sandstone_smooth_slab>,        
    <quark:sandstone_new:5> : <quark:soul_sandstone_bricks_slab>,        
    //<quark:hardened_clay_tiles> : <quark:hardened_clay_tiles_slab>,        
    //<quark:stained_clay_tiles> : <quark:stained_clay_tiles_white_slab>,
    //<quark:stained_clay_tiles:1> : <quark:stained_clay_tiles_orange_slab>,
    //<quark:stained_clay_tiles:2> : <quark:stained_clay_tiles_magenta_slab>,
    //<quark:stained_clay_tiles:3> : <quark:stained_clay_tiles_light_blue_slab>,
    //<quark:stained_clay_tiles:4> : <quark:stained_clay_tiles_yellow_slab>,
    //<quark:stained_clay_tiles:5> : <quark:stained_clay_tiles_lime_slab>,
    //<quark:stained_clay_tiles:6> : <quark:stained_clay_tiles_pink_slab>,
    //<quark:stained_clay_tiles:7> : <quark:stained_clay_tiles_gray_slab>,
    //<quark:stained_clay_tiles:8> : <quark:stained_clay_tiles_silver_slab>,
    //<quark:stained_clay_tiles:9> : <quark:stained_clay_tiles_cyan_slab>,
    //<quark:stained_clay_tiles:10> : <quark:stained_clay_tiles_purple_slab>,
    //<quark:stained_clay_tiles:11> : <quark:stained_clay_tiles_blue_slab>,
    //<quark:stained_clay_tiles:12> : <quark:stained_clay_tiles_brown_slab>,
    //<quark:stained_clay_tiles:13> : <quark:stained_clay_tiles_green_slab>,
    //<quark:stained_clay_tiles:14> : <quark:stained_clay_tiles_red_slab>,
    //<quark:stained_clay_tiles:15> : <quark:stained_clay_tiles_black_slab>,       
    <quark:iron_plate> : <quark:iron_plate_slab>, 
    //<quark:sandy_bricks> : <quark:sandy_bricks_slab>, 
    <minecraft:stone:1> : <quark:stone_granite_slab>, 
    <minecraft:stone:3> : <quark:stone_diorite_slab>, 
    <minecraft:stone:5> : <quark:stone_andesite_slab>, 
    <minecraft:end_bricks> : <quark:end_bricks_slab>, 
    <minecraft:prismarine> : <quark:prismarine_slab>, 
    <minecraft:prismarine:1> : <quark:prismarine_bricks_slab>, 
    <minecraft:prismarine:2> : <quark:prismarine_dark_slab>, 
    <minecraft:red_nether_brick> : <quark:red_nether_brick_slab>, 
    <minecraft:mossy_cobblestone> : <quark:cobblestone_mossy_slab>, 
    <minecraft:stonebrick:1> : <quark:stonebrick_mossy_slab>, 
    <quark:thatch> : <quark:thatch_slab>, 
    <quark:charred_nether_bricks> : <quark:charred_nether_brick_slab>, 
    <quark:world_stone_bricks> : <quark:stone_granite_bricks_slab>, 
    <quark:world_stone_bricks:1> : <quark:stone_diorite_bricks_slab>, 
    <quark:world_stone_bricks:2> : <quark:stone_andesite_bricks_slab>, 
    //<quark:world_stone_bricks:3> : <quark:stone_basalt_bricks_slab>, 
    //<quark:world_stone_bricks:4> : <quark:stone_marble_bricks_slab>, 
    //<quark:world_stone_bricks:5> : <quark:stone_limestone_bricks_slab>, 
    <quark:world_stone_bricks:6> : <quark:stone_jasper_bricks_slab>, 
    <quark:world_stone_bricks:7> : <quark:stone_slate_bricks_slab>, 
    <quark:midori_block> : <quark:midori_block_slab>, 
    <quark:magma_bricks> : <quark:magma_bricks_slab>, 
    <quark:duskbound_block> : <quark:duskbound_block_slab>, 
    <quark:reed_block> : <quark:reed_block_slab>, 
    <quark:snow_bricks> : <quark:snow_bricks_slab>, 
    <quark:soul_sandstone> : <quark:soul_sandstone_slab>, 
    <quark:turf> : <quark:turf_slab>, 
    <quark:polished_netherrack:1> : <quark:polished_netherrack_bricks_slab>, 
    <roots:runestone> : <roots:runestone_slab>, 
    <roots:runestone_brick> : <roots:runestone_brick_slab>, 
    <roots:runestone_brick_alt> : <roots:runestone_brick_alt_slab>, 
    <roots:runed_obsidian> : <roots:runed_obsidian_slab>, 
    <roots:runed_obsidian_brick> : <roots:runed_obsidian_brick_slab>, 
    <roots:runed_obsidian_brick_alt> : <roots:runed_obsidian_brick_alt_slab>, 
    //<rustic:slate_roof> : <rustic:slate_roof_slab_item>, 
    //<rustic:slate_brick> : <rustic:slate_brick_slab_item>, 
    <tconstruct:deco_ground> : <tconstruct:deco_ground_slab>, 
    <tconstruct:firewood> : <tconstruct:firewood_slab>, 
    <tconstruct:firewood:1> : <tconstruct:firewood_slab:1>, 
    <tconstruct:seared> : <tconstruct:seared_slab>, 
    <tconstruct:seared:1> : <tconstruct:seared_slab:1>, 
    <tconstruct:seared:2> : <tconstruct:seared_slab:2>, 
    <tconstruct:seared:3> : <tconstruct:seared_slab:3>, 
    <tconstruct:seared:4> : <tconstruct:seared_slab:4>, 
    <tconstruct:seared:5> : <tconstruct:seared_slab:5>, 
    <tconstruct:seared:6> : <tconstruct:seared_slab:6>, 
    <tconstruct:seared:7> : <tconstruct:seared_slab:7>, 
    <tconstruct:seared:8> : <tconstruct:seared_slab2>, 
    <tconstruct:seared:9> : <tconstruct:seared_slab2:1>, 
    <tconstruct:seared:10> : <tconstruct:seared_slab2:2>, 
    <tconstruct:seared:11> : <tconstruct:seared_slab2:3>, 
    <tconstruct:dried_clay> : <tconstruct:dried_clay_slab>, 
    <tconstruct:dried_clay:1> : <tconstruct:dried_clay_slab:1>, 
    <tconstruct:brownstone> : <tconstruct:brownstone_slab>, 
    <tconstruct:brownstone:1> : <tconstruct:brownstone_slab:1>, 
    <tconstruct:brownstone:2> : <tconstruct:brownstone_slab:2>, 
    <tconstruct:brownstone:3> : <tconstruct:brownstone_slab:3>, 
    <tconstruct:brownstone:4> : <tconstruct:brownstone_slab:4>, 
    <tconstruct:brownstone:5> : <tconstruct:brownstone_slab:5>, 
    <tconstruct:brownstone:6> : <tconstruct:brownstone_slab:6>, 
    <tconstruct:brownstone:7> : <tconstruct:brownstone_slab:7>, 
    <tconstruct:brownstone:8> : <tconstruct:brownstone_slab2>, 
    <tconstruct:brownstone:9> : <tconstruct:brownstone_slab2:1>, 
    <tconstruct:brownstone:10> : <tconstruct:brownstone_slab2:2>, 
    <tconstruct:brownstone:11> : <tconstruct:brownstone_slab2:3>, 
    <traverse:red_rock_bricks> : <traverse:red_rock_bricks_slab>, 
    <traverse:red_rock> : <traverse:red_rock_slab>, 
    <traverse:red_rock_cobblestone> : <traverse:red_rock_cobblestone_slab>, 
    <traverse:blue_rock_bricks> : <traverse:blue_rock_bricks_slab>, 
    <traverse:blue_rock> : <traverse:blue_rock_slab>, 
    <traverse:blue_rock_cobblestone> : <traverse:blue_rock_cobblestone_slab>, 
    //<undergroundbiomes:igneous_stone> : <undergroundbiomes:igneous_stone_halfslab>, 
    //<undergroundbiomes:igneous_stone:1> : <undergroundbiomes:igneous_stone_halfslab:1>, 
    //<undergroundbiomes:igneous_stone:2> : <undergroundbiomes:igneous_stone_halfslab:2>, 
    //<undergroundbiomes:igneous_stone:3> : <undergroundbiomes:igneous_stone_halfslab:3>, 
    //<undergroundbiomes:igneous_stone:4> : <undergroundbiomes:igneous_stone_halfslab:4>, 
    //<undergroundbiomes:igneous_stone:5> : <undergroundbiomes:igneous_stone_halfslab:5>, 
    //<undergroundbiomes:igneous_stone:6> : <undergroundbiomes:igneous_stone_halfslab:6>, 
    //<undergroundbiomes:igneous_stone:7> : <undergroundbiomes:igneous_stone_halfslab:7>, 
    //<undergroundbiomes:metamorphic_stone> : <undergroundbiomes:metamorphic_stone_halfslab>, 
    //<undergroundbiomes:metamorphic_stone:1> : <undergroundbiomes:metamorphic_stone_halfslab:1>, 
    //<undergroundbiomes:metamorphic_stone:2> : <undergroundbiomes:metamorphic_stone_halfslab:2>, 
    //<undergroundbiomes:metamorphic_stone:3> : <undergroundbiomes:metamorphic_stone_halfslab:3>, 
    //<undergroundbiomes:metamorphic_stone:4> : <undergroundbiomes:metamorphic_stone_halfslab:4>, 
    //<undergroundbiomes:metamorphic_stone:5> : <undergroundbiomes:metamorphic_stone_halfslab:5>, 
    //<undergroundbiomes:metamorphic_stone:6> : <undergroundbiomes:metamorphic_stone_halfslab:6>, 
    //<undergroundbiomes:metamorphic_stone:7> : <undergroundbiomes:metamorphic_stone_halfslab:7>, 
    //<undergroundbiomes:igneous_cobble> : <undergroundbiomes:igneous_cobble_halfslab>, 
    //<undergroundbiomes:igneous_cobble:1> : <undergroundbiomes:igneous_cobble_halfslab:1>, 
    //<undergroundbiomes:igneous_cobble:2> : <undergroundbiomes:igneous_cobble_halfslab:2>,
    //<undergroundbiomes:igneous_cobble:3> : <undergroundbiomes:igneous_cobble_halfslab:3>,
    //<undergroundbiomes:igneous_cobble:4> : <undergroundbiomes:igneous_cobble_halfslab:4>,
    //<undergroundbiomes:igneous_cobble:5> : <undergroundbiomes:igneous_cobble_halfslab:5>,
    //<undergroundbiomes:igneous_cobble:6> : <undergroundbiomes:igneous_cobble_halfslab:6>,
    //<undergroundbiomes:igneous_cobble:7> : <undergroundbiomes:igneous_cobble_halfslab:7>,
    //<undergroundbiomes:metamorphic_cobble> : <undergroundbiomes:metamorphic_cobble_halfslab>, 
    //<undergroundbiomes:metamorphic_cobble:1> : <undergroundbiomes:metamorphic_cobble_halfslab:1>, 
    //<undergroundbiomes:metamorphic_cobble:2> : <undergroundbiomes:metamorphic_cobble_halfslab:2>,
    //<undergroundbiomes:metamorphic_cobble:3> : <undergroundbiomes:metamorphic_cobble_halfslab:3>,
    //<undergroundbiomes:metamorphic_cobble:4> : <undergroundbiomes:metamorphic_cobble_halfslab:4>,
    //<undergroundbiomes:metamorphic_cobble:5> : <undergroundbiomes:metamorphic_cobble_halfslab:5>,
    //<undergroundbiomes:metamorphic_cobble:6> : <undergroundbiomes:metamorphic_cobble_halfslab:6>,
    //<undergroundbiomes:metamorphic_cobble:7> : <undergroundbiomes:metamorphic_cobble_halfslab:7>,
    //<undergroundbiomes:sedimentary_stone> : <undergroundbiomes:sedimentary_stone_halfslab>,
    //<undergroundbiomes:sedimentary_stone:1> : <undergroundbiomes:sedimentary_stone_halfslab:1>,
    //<undergroundbiomes:sedimentary_stone:2> : <undergroundbiomes:sedimentary_stone_halfslab:2>,
    //<undergroundbiomes:sedimentary_stone:3> : <undergroundbiomes:sedimentary_stone_halfslab:3>,
    //<undergroundbiomes:sedimentary_stone:4> : <undergroundbiomes:sedimentary_stone_halfslab:4>,
    //<undergroundbiomes:sedimentary_stone:5> : <undergroundbiomes:sedimentary_stone_halfslab:5>,
    //<undergroundbiomes:sedimentary_stone:6> : <undergroundbiomes:sedimentary_stone_halfslab:6>,
    //<undergroundbiomes:sedimentary_stone:7> : <undergroundbiomes:sedimentary_stone_halfslab:7>,
    //<undergroundbiomes:igneous_brick> : <undergroundbiomes:igneous_brick_halfslab>,
    //<undergroundbiomes:igneous_brick:1>: <undergroundbiomes:igneous_brick_halfslab:1>,
    //<undergroundbiomes:igneous_brick:2>: <undergroundbiomes:igneous_brick_halfslab:2>,
    //<undergroundbiomes:igneous_brick:3>: <undergroundbiomes:igneous_brick_halfslab:3>,
    //<undergroundbiomes:igneous_brick:4>: <undergroundbiomes:igneous_brick_halfslab:4>,
    //<undergroundbiomes:igneous_brick:5>: <undergroundbiomes:igneous_brick_halfslab:5>,
    //<undergroundbiomes:igneous_brick:6>: <undergroundbiomes:igneous_brick_halfslab:6>,
    //<undergroundbiomes:igneous_brick:7>: <undergroundbiomes:igneous_brick_halfslab:7>,
    //<undergroundbiomes:metamorphic_brick> : <undergroundbiomes:metamorphic_brick_halfslab>,
    //<undergroundbiomes:metamorphic_brick:1>: <undergroundbiomes:metamorphic_brick_halfslab:1>,
    //<undergroundbiomes:metamorphic_brick:2>: <undergroundbiomes:metamorphic_brick_halfslab:2>,
    //<undergroundbiomes:metamorphic_brick:3>: <undergroundbiomes:metamorphic_brick_halfslab:3>,
    //<undergroundbiomes:metamorphic_brick:4>: <undergroundbiomes:metamorphic_brick_halfslab:4>,
    //<undergroundbiomes:metamorphic_brick:5>: <undergroundbiomes:metamorphic_brick_halfslab:5>,
    //<undergroundbiomes:metamorphic_brick:6>: <undergroundbiomes:metamorphic_brick_halfslab:6>,
    //<undergroundbiomes:metamorphic_brick:7>: <undergroundbiomes:metamorphic_brick_halfslab:7>,
    <minecraft:quartz_block> : <minecraft:stone_slab:7>,
    <fossil:ancient_stone_brick>: <fossil:ancient_stone_slab>,
    <fossil:volcanic_brick>: <fossil:volcanic_slab>,
    <embers:block_caminite_brick>: <embers:block_caminite_brick_slab>,
    <embers:ashen_stone>: <embers:ashen_stone_slab>,
    <embers:ashen_brick>: <embers:ashen_brick_slab>,
    <embers:ashen_tile>: <embers:ashen_tile_slab>,
    <ceramics:clay_hard>: <ceramics:clay_slab>,
    <ceramics:clay_hard:1>: <ceramics:clay_slab:1>,
    <ceramics:clay_hard:2>: <ceramics:clay_slab:2>,
    <ceramics:clay_hard:3>: <ceramics:clay_slab:3>,
    <ceramics:clay_hard:4>: <ceramics:clay_slab:4>,
    <ceramics:clay_hard:5>: <ceramics:clay_slab:5>,
    <ceramics:clay_hard:6>: <ceramics:clay_slab:6>,
    <ceramics:clay_hard:7>: <ceramics:clay_slab:7>,
    <tcomplement:scorched_block>: <tcomplement:scorched_slab>,
    <tcomplement:scorched_block:1>: <tcomplement:scorched_slab:1>,
    <tcomplement:scorched_block:2>: <tcomplement:scorched_slab:2>,
    <tcomplement:scorched_block:3>: <tcomplement:scorched_slab:3>,
    <tcomplement:scorched_block:4>: <tcomplement:scorched_slab:4>,
    <tcomplement:scorched_block:5>: <tcomplement:scorched_slab:5>,
    <tcomplement:scorched_block:6>: <tcomplement:scorched_slab:6>,
    <tcomplement:scorched_block:7>: <tcomplement:scorched_slab:7>,
    <tcomplement:scorched_block:8>: <tcomplement:scorched_slab2>,
    <tcomplement:scorched_block:9>: <tcomplement:scorched_slab2:1>,
    <tcomplement:scorched_block:10>: <tcomplement:scorched_slab2:2>,
    <tcomplement:scorched_block:11>: <tcomplement:scorched_slab2:3>,
    <twilightforest:aurora_block>: <twilightforest:aurora_slab>,
    <abyssalcraft:darkstone_brick>: <abyssalcraft:darkbrickslab1>,
    <abyssalcraft:cobblestone>: <abyssalcraft:darkcobbleslab1>,
    <abyssalcraft:abybrick>: <abyssalcraft:abyslab1>,
    <abyssalcraft:stone>: <abyssalcraft:darkstoneslab1>,
    <abyssalcraft:dreadbrick>: <abyssalcraft:dreadbrickslab1>,
    <abyssalcraft:abydreadbrick>: <abyssalcraft:abydreadbrickslab1>,
    <abyssalcraft:cstonebrick>: <abyssalcraft:cstonebrickslab1>,
    <abyssalcraft:ethaxiumbrick>: <abyssalcraft:ethaxiumbrickslab1>,
    <abyssalcraft:darkethaxiumbrick>: <abyssalcraft:darkethaxiumbrickslab1>,
    <abyssalcraft:cobblestone:1>: <abyssalcraft:abyssalcobblestoneslab1>,
    <abyssalcraft:cobblestone:2>: <abyssalcraft:dreadstonecobblestoneslab1>,
    <abyssalcraft:cobblestone:3>: <abyssalcraft:abyssalnitecobblestoneslab1>,
    <abyssalcraft:cobblestone:4>: <abyssalcraft:coraliumcobblestoneslab1>,
    <botania:livingrock>: <botania:livingrock0slab>,
    <botania:livingrock:1>: <botania:livingrock1slab>,
    <botania:quartztypedark>: <botania:quartzslabdarkhalf>,
    <botania:quartztypemana>: <botania:quartzslabmanahalf>,
    <botania:quartztypeblaze>: <botania:quartzslabblazehalf>,
    <botania:quartztypelavender>: <botania:quartzslablavenderhalf>,
    <botania:quartztypered>: <botania:quartzslabredhalf>,
    <botania:quartztypeelf>: <botania:quartzslabelfhalf>,
    <botania:quartztypesunny>: <botania:quartzslabsunnyhalf>,
    <botania:biomestonea>: <botania:biomestonea0slab>,
    <botania:biomestonea:1>: <botania:biomestonea1slab>,
    <botania:biomestonea:2>: <botania:biomestonea2slab>,
    <botania:biomestonea:3>: <botania:biomestonea3slab>,
    <botania:biomestonea:4>: <botania:biomestonea4slab>,
    <botania:biomestonea:5>: <botania:biomestonea5slab>,
    <botania:biomestonea:6>: <botania:biomestonea6slab>,
    <botania:biomestonea:7>: <botania:biomestonea7slab>,
    <botania:biomestonea:8>: <botania:biomestonea8slab>,
    <botania:biomestonea:9>: <botania:biomestonea9slab>,
    <botania:biomestonea:10>: <botania:biomestonea10slab>,
    <botania:biomestonea:11>: <botania:biomestonea11slab>,
    <botania:biomestonea:12>: <botania:biomestonea12slab>,
    <botania:biomestonea:13>: <botania:biomestonea13slab>,
    <botania:biomestonea:14>: <botania:biomestonea14slab>,
    <botania:biomestonea:15>: <botania:biomestonea15slab>,
    <botania:biomestoneb>: <botania:biomestoneb0slab>,
    <botania:biomestoneb:1>: <botania:biomestoneb1slab>,
    <botania:biomestoneb:2>: <botania:biomestoneb2slab>,
    <botania:biomestoneb:3>: <botania:biomestoneb3slab>,
    <botania:biomestoneb:4>: <botania:biomestoneb4slab>,
    <botania:biomestoneb:5>: <botania:biomestoneb5slab>,
    <botania:biomestoneb:6>: <botania:biomestoneb6slab>,
    <botania:biomestoneb:7>: <botania:biomestoneb7slab>,
    <botania:pavement>: <botania:pavement0slab>,
    <botania:pavement:1>: <botania:pavement1slab>,
    <botania:pavement:2>: <botania:pavement2slab>,
    <botania:pavement:3>: <botania:pavement3slab>,
    <botania:pavement:4>: <botania:pavement4slab>,
    <botania:pavement:5>: <botania:pavement5slab>,
    <botania:shimmerrock>: <botania:shimmerrock0slab>,
    <botania:shimmerwoodplanks>: <botania:shimmerwoodplanks0slab>,
    <astralsorcery:blockmarble:1>: <astralsorcery:blockmarbleslab>,

    <natura:colored_grass:2>: <natura:colored_grass_slab:2>,
    <natura:colored_grass:1>: <natura:colored_grass_slab:1>,
    <natura:colored_grass>: <natura:colored_grass_slab>,

    <pyrotech:masonry_brick_block>: <pyrotech:masonry_brick_slab>,
    <pyrotech:refractory_brick_block>: <pyrotech:refractory_brick_slab>

    };

for IItemStack, IIngredient in NonWoodSlabs {
        recipes.remove(IIngredient);

        recipes.addShapeless(IIngredient * 2, [IItemStack, <ore:gtceSaws>]);

		saw.recipeBuilder()
			.inputs(IItemStack)
			.outputs(IIngredient * 2)
			.duration(50)
			.EUt(8)
			.buildAndRegister();
        
        mods.advancedrocketry.CuttingMachine.addRecipe(IIngredient*4, 100/*ticks*/, 800/*rf/t*/, IItemStack);
}

# Specific Vanilla Woods that need a Recipe with a Saw by Hand

//Stone Slab
recipes.removeByRecipeName("quark:stone_slab");
recipes.addShapeless(<minecraft:stone_slab> * 2, [<minecraft:stone>, <ore:gtceSaws>]);

//Cobblestone Slab
recipes.addShapeless(<minecraft:stone_slab:3> * 2, [<minecraft:cobblestone>, <ore:gtceSaws>]);

//Bricks 
recipes.addShapeless(<minecraft:stone_slab:4> * 2, [<minecraft:brick_block>, <ore:gtceSaws>]);

//Stone Bricks 
recipes.addShapeless(<minecraft:stone_slab:5> * 2, [<minecraft:stonebrick>, <ore:gtceSaws>]);

//Nether Bricks 
recipes.addShapeless(<minecraft:stone_slab:6> * 2, [<minecraft:nether_brick>, <ore:gtceSaws>]);

// Problematic Slabs/Other Recipes

var PlanksToSlabs2 as IItemStack[IIngredient] = {
    <botania:livingwood>: <botania:livingwood0slab>,
    <botania:dreamwood>: <botania:dreamwood0slab>,
    };
for IItemStack, IIngredient in PlanksToSlabs2 {
        recipes.remove(IIngredient);
        SagMill.addRecipe([IIngredient * 2, <ore:dustWood>.firstItem], [1.0, 0.5], IItemStack, "CHANCE_ONLY");
}